package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("关卡列表信息")
@Data
public class MissionListDto implements Serializable {

    private static final long serialVersionUID = -2769967824361351859L;
    @ApiModelProperty(notes = "主键")
    private Long id;

    @ApiModelProperty(notes = "关卡code")
    private String missionCode;

    @ApiModelProperty(notes = "名称")
    private String missionName;

    @ApiModelProperty(notes = "序号")
    private Integer missionIndex;

    @ApiModelProperty(notes = "关卡在地图位置(坐标)")
    private String missionCoords;

    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测")
    private Integer missionType;

    @ApiModelProperty(notes = "父关卡(nature为神秘关卡不能为空)")
    private String parentCode;

    @ApiModelProperty(notes = "支线信息")
    private MissionListDto child;
}
