package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * @author LiBin
 */
@ApiModel("关卡图标集合")
@Data
public class MissionIcoDto implements Serializable {

    private static final long serialVersionUID = 8890744102993145660L;
    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测")
    private Integer missionType;

    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测")
    private Map<Integer, List<IcoGroupDto>> icoGroupMap;

    @ApiModelProperty(notes = "课程图标组")
    private List<IcoGroupDto> courseIcoGroupList;

    @ApiModelProperty(notes = "考试图标组")
    private List<IcoGroupDto> examIcoGroupList;

    @ApiModelProperty(notes = "测验图标组")
    private List<IcoGroupDto> testIcoGroupList;

    @ApiModelProperty(notes = "蓝思图标组")
    private List<IcoGroupDto> lexileIcoGroupList;

    @ApiModelProperty(notes = "隐藏关卡(绘本)图标组")
    private List<IcoGroupDto> hideIcoGroupList;


}
