package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("关卡详细信息")
public class MissionFullDto implements Serializable {

    private static final long serialVersionUID = 204438158449207064L;


    @ApiModelProperty(notes = "主键")
    private Integer id;

    @ApiModelProperty(notes = "关卡code")
    private String missionCode;

    @ApiModelProperty(notes = "名称")
    private String missionName;

    @ApiModelProperty("所属等级code")
    private String levelCode;

    @ApiModelProperty("所属等级名称")
    private String levelName;

    @ApiModelProperty(notes = "地图code")
    private String mapCode;

    @ApiModelProperty("地图名称")
    private String mapName;

    @ApiModelProperty("地图所在等级位置序号")
    private Integer levelOrder;

    @ApiModelProperty(notes = "序号")
    private Integer missionIndex;

    @ApiModelProperty(notes = "关卡在地图位置(坐标)")
    private String missionCoords;

    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测")
    private Integer missionType;

    @ApiModelProperty(notes = "资源id")
    private Integer resourceId;

    @ApiModelProperty(notes = "资源名称")
    private String resourceName;

}
