package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("关卡信息")
@Data
public class MissionDto implements Serializable {

    private static final long serialVersionUID = -319557345650783084L;
    @ApiModelProperty(notes = "主键")
    private Long id;

    @ApiModelProperty(notes = "关卡code")
    private String missionCode;

    @ApiModelProperty(notes = "名称")
    private String missionName;

    @ApiModelProperty(notes = "地图code")
    private String mapCode;

    @ApiModelProperty(notes = "序号")
    private Integer missionIndex;

    @ApiModelProperty(notes = "关卡在地图位置(坐标)")
    private String missionCoords;

    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测")
    private Integer missionType;

    @ApiModelProperty(notes = "资源id")
    private Integer resourceId;

    @ApiModelProperty(notes = "资源名称")
    private String resourceName;

    @ApiModelProperty(notes = "父关卡(nature为神秘关卡不能为空)")
    private String parentCode;

    @ApiModelProperty(notes = "过关答题正确数")
    private Integer passNum;

    @ApiModelProperty(notes = "关卡能量石个数")
    private Integer missionStoneNum;

    @ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
    private String status;
}
