package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

@Data
@ApiModel("关卡详情页信息(阶段性测验、考试共用)")
public class MissionDetailPageDto implements Serializable {

    private static final long serialVersionUID = 1L;

    @ApiModelProperty(notes = "题目数量")
    private int questionNums;

    @ApiModelProperty(notes = "预计用时(单位为分钟)")
    private int usedTime;

    @ApiModelProperty(notes = "过关奖励能量石数")
    private int awardStoneNum;

    @ApiModelProperty(notes = "余额")
    private String balance;

    @ApiModelProperty(notes = "拥有能量石数")
    private int stoneNums;

    @ApiModelProperty(notes = "是否可以点击")
    private boolean isClickAble;

    @ApiModelProperty(notes = "关卡序号")
    private Integer missionIndex;

    @ApiModelProperty(notes = "答题记录 true:有 false:无")
    private Boolean recordFlag;

    @ApiModelProperty(notes = "蓝思级别code")
    private String levelCode;

    @ApiModelProperty(notes = "地图所在等级位置序号")
    private Integer levelOrder;

    @ApiModelProperty(notes = "是否是新增关卡")
    private Boolean isNew = false;
}
