package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("图标组")
@Data
public class IcoGroupDto implements Serializable {

    private static final long serialVersionUID = 8890744102993145660L;

    @ApiModelProperty(notes = "资源id)")
    private Integer id;

    @ApiModelProperty(notes = "图标状态1：未解锁   2：已解锁   3：已下架   4：已完成 5：未完成")
    private Integer icoStatus;

    @ApiModelProperty(notes = "图标url")
    private String icoUrl;

    public IcoGroupDto(Integer icoStatus, String icoUrl, Integer id) {
        this.icoStatus = icoStatus;
        this.icoUrl = icoUrl;
        this.id = id;
    }

    public IcoGroupDto() {

    }
}
