package com.ella.resource.dto.missiondto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("动效组")
@Data
public class DynamicDto implements Serializable {

    private static final long serialVersionUID = 3107986140497386643L;

    @ApiModelProperty(notes = "资源id)")
    private Integer id;

    @ApiModelProperty(notes = "序号0,1,2,3,4,5,6(0表示首页动效)")
    private Integer fileOrder;

    @ApiModelProperty(notes = "路径")
    private String filePath;

    public DynamicDto(Integer fileOrder, String filePath, Integer id) {
        this.fileOrder = null == fileOrder ? 0 : fileOrder;
        this.filePath = filePath;
        this.id = id;
    }

    public DynamicDto() {
    }
}
