package com.ella.resource.dto.lexile;

import lombok.Data;

/**
 * 蓝思评测接口返回类
 * <p>
 * {jsonrpc: "2.0", result: {sem: 106, raw_score: 30, ability: 849},
 * id:"djangorpc"}
 * <p/>
 *
 * @author maofengHan
 */
@Data
public class LexileR2bScoreResponse {
    private String id;
    private String jsonrpc;
    private Result result;
    private Error error;

    @Data
    public static class Result {
        /**
         *  the student's new ability estimate
         */
        int b_new;
        /**
         * Uncertainty associated with the student's new ability estimate
         */
         int sigma_new;
    }

    @Data
    public static class Error {
        int code;
        String message;
        String name;
    }
}
