package com.ella.resource.dto.ellacoin;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

@ApiModel("咿啦币配置dto")
@Data
public class CoinConfigDto implements Serializable {

    private static final long serialVersionUID = 3853565529045847881L;

    @ApiModelProperty("咿啦币编码")
    private String coinCode;

    @ApiModelProperty("价格")
    private BigDecimal price;

    @ApiModelProperty("显示的价格文本")
    private String priceContent;

    @ApiModelProperty("ios价格认证编码")
    private String iosPriceCode;

    @ApiModelProperty("咿啦币数量")
    private Integer coin;

    @ApiModelProperty("咿啦币文本描述")
    private String coinDesc;

    @ApiModelProperty("赠送金额")
    private BigDecimal giftPrice;

    @ApiModelProperty("赠送文本描述")
    private String giftDesc;

    @ApiModelProperty("价格描述")
    private String priceDesc;

    @ApiModelProperty("序号")
    private Integer idx;

    @ApiModelProperty("序号")
    private String type;
}
