package com.ella.resource.dto.appdto;

import com.ella.resource.dto.missiondto.DynamicDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author LiBin
 */
@ApiModel("用户关卡列表")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class UserMissionListDto implements Serializable {
    private static final long serialVersionUID = -3151258268311414739L;
    @ApiModelProperty("咿啦币数")
    private String balance;

    @ApiModelProperty("能量石数")
    private Integer stoneNum;

    @ApiModelProperty("关卡列表所属地图是不是新增")
    private Boolean isNew = false;

    @ApiModelProperty("地图背景")
    private String backgroundUrl;

    @ApiModelProperty("动效组")
    private List<DynamicDto> dynamicDtoList;

    @ApiModelProperty("关卡列表")
    private List<UserMissionDto> userMissionDtoList;

    @ApiModelProperty("弹窗数据")
    private LevelPopupDto levelPopupDto;

    @ApiModelProperty("地图底部图片")
    private String bottomUrl;

    @ApiModelProperty(notes = "是否闯关会员 Y-是 N-否")
    private String isVip;

    @ApiModelProperty(notes = "会员开始时间")
    private Date vipBegin;

    @ApiModelProperty(notes = "会员结束时间")
    private Date vipEnd;

    @ApiModelProperty(notes = "是否闯关新用户")
    private Boolean newMapUser;

    @ApiModelProperty(notes = "是否游客 Y 是")
    private String isVisitor;

    @ApiModelProperty("当前地图是否有新的阅读报告")
    private Boolean newReport;

    @ApiModelProperty("当前地图是否显示阅读报告")
    private Boolean showReport;
    /**
     * IRA报告用字段
     */
    @ApiModelProperty("当前地图mapCode")
    private String mapCode;

    private String mapName;

    private String levelCode;

    private Integer missionNum;
}
