package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("用户关卡信息")
@Data
@Builder
@AllArgsConstructor
public class UserMissionDto implements Serializable {
    private static final long serialVersionUID = -2180140645958190950L;

    @ApiModelProperty(notes = "主键")
    private Long id;

    @ApiModelProperty(notes = "地图code")
    private String mapCode;

    @ApiModelProperty(notes = "关卡code")
    private String missionCode;

    @ApiModelProperty(notes = "名称")
    private String missionName;

    @ApiModelProperty(notes = "序号")
    private Integer missionIndex;

    @ApiModelProperty(notes = "关卡在地图位置(坐标)")
    private String missionCoords;

    @ApiModelProperty(notes = "关卡类型 0：神秘关卡 1:课程  2:阶段性测验 3:考试  4：蓝思评测")
    private Integer missionType;

    @ApiModelProperty(notes = "关卡图标")
    private String ioc;

    @ApiModelProperty("关卡状态")
    private String status;

    @ApiModelProperty("是否正在进行的关卡")
    private Boolean isDoing;

    @ApiModelProperty("是否有新关卡")
    private Boolean isNew;

    public UserMissionDto() {
    }

    public UserMissionDto(Integer id, String missionCode, String missionName, Integer missionIndex, String missionCoords, Integer missionType) {
        this.id = id.longValue();
        this.missionCode = missionCode;
        this.missionName = missionName;
        this.missionIndex = missionIndex;
        this.missionCoords = missionCoords;
        this.missionType = missionType;
    }
}
