package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("用户地图列表")
@Data
@Builder
@AllArgsConstructor
public class UserMapListDto implements Serializable {
    private static final long serialVersionUID = 7999592335775165923L;

    @ApiModelProperty(notes = "主键")
    private Long id;

    @ApiModelProperty("地图名")
    private String mapName;

    @ApiModelProperty("所属等级名称")
    private String levelName;

    @ApiModelProperty("所属等级code")
    private String levelCode;

    @ApiModelProperty("地图动效")
    private String dynamicUrl;

    @ApiModelProperty("总的关卡数")
    private Integer missionNum = 0;

    @ApiModelProperty("已过关卡数")
    private Integer userMissionNum = 0;

    @ApiModelProperty("地图状态 UNLOCKED:已解锁;LOCKED:未解锁")
    private String status;

    @ApiModelProperty("地图序号")
    private Integer mapIndex;

    @ApiModelProperty("是否正在进行的地图")
    private Boolean isDoing = false;

    @ApiModelProperty("是否有新增地图")
    private Boolean isNew = false;

    @ApiModelProperty("地图图标")
    private String icoUrl;

    @ApiModelProperty("地图进行的状态 已过关(PASS) 进行中(DOING) 未开始(NOTSTARTED)")
    private String processStatus;
    private String mapCode;
    public UserMapListDto() {
    }

    public UserMapListDto(Long id, String mapName, String levelName, String levelCode, String dynamicUrl, Integer missionNum) {
        this.id = id;
        this.mapName = mapName;
        this.levelName = levelName;
        this.levelCode = levelCode;
        this.dynamicUrl = dynamicUrl;
        this.missionNum = missionNum;
    }

    public UserMapListDto(Integer id, String mapName, String levelName, String levelCode, String dynamicUrl, Integer missionNum, String icoUrl, String status) {
        this.id = id.longValue();
        this.mapName = mapName;
        this.levelName = levelName;
        this.levelCode = levelCode;
        this.dynamicUrl = dynamicUrl;
        this.missionNum = missionNum;
        this.icoUrl = icoUrl;
        this.status = status;
    }
}
