package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("用户地图信息")
@Data
@AllArgsConstructor
@Builder
public class UserMapDto implements Serializable {

    private static final long serialVersionUID = -5743301183779733531L;
    @ApiModelProperty(notes = "主键")
    private Long id;

    @ApiModelProperty("地图名")
    private String mapName;

    @ApiModelProperty("地图动效")
    private String dynamicUrl;

    @ApiModelProperty("总的关卡数")
    private Integer missionNum = 0;

    @ApiModelProperty("已过关卡数")
    private Integer userMissionNum = 0;

    @ApiModelProperty("已获得能量石数")
    private Integer gotStoneNum = 0;

    @ApiModelProperty("还可以获得能量石数")
    private Integer surplusStoneNum = 0;

    @ApiModelProperty("地图序号")
    private Integer mapIndex;

    @ApiModelProperty("地图状态")
    private String status;

    @ApiModelProperty("地图图标")
    private String icoUrl;

    @ApiModelProperty("地图进行的状态 已过关(PASS) 进行中(DOING) 未开始(NOTSTARTED)")
    private String processStatus;

    public UserMapDto() {
    }

    public UserMapDto(String mapName) {
        this.mapName = mapName;
    }

    public UserMapDto(String mapName, Integer missionNum, String dynamicUrl, String status, Long id) {
        this.mapName = mapName;
        this.missionNum = missionNum;
        this.dynamicUrl = dynamicUrl;
        this.status = status;
        this.id = id;
    }

}
