package com.ella.resource.dto.appdto;

import com.ella.resource.dto.ResExamDetailDto;
import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author LiBin
 */
@ApiModel("测验题目列表")
@Data
public class TestRecordDto implements Serializable {
    private static final long serialVersionUID = 8845007718970906464L;

    @ApiModelProperty("咿啦币数")
    private String balance;

    @ApiModelProperty("总能量石数")
    private Integer stoneNum;

    @ApiModelProperty(notes = "英文名称")
    private String enName;

    @ApiModelProperty("跳转列表")
    private List<NextMissionInfoDto> contentFroms;

    @ApiModelProperty("通关答题数")
    private Integer passNum = 0;

    @ApiModelProperty("错题数")
    private Integer errorNum = 0;

    @ApiModelProperty(notes = "是否过关")
    private Boolean isPass;

    @ApiModelProperty("下一关卡信息")
    private NextMissionInfoDto nextMissionInfo;

    private String uid;
}
