package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @Author Cui
 */
@ApiModel("分享页结果数据")
@Data
public class SharePassResultDto implements Serializable {

    private static final long serialVersionUID = 2976276588044253863L;

    @ApiModelProperty("阅读时长")
    private Integer learnTime;

    @ApiModelProperty("读音准确度")
    private Double speechAccuracy;

    @ApiModelProperty("读音流利度")
    private Double speechFluency;

    @ApiModelProperty("跟读单词")
    private Integer followWordNum;

    @ApiModelProperty("收藏单词")
    private Integer collectedWordNum;

    @ApiModelProperty("跟读句子")
    private Integer followSentenceNum;

    @ApiModelProperty("总能量石")
    private Integer stoneNum;

    @ApiModelProperty("阅读总时间")
    private Integer learnTimeToal;

    @ApiModelProperty("阅读总数量")
    private Integer readBookNum;

    @ApiModelProperty("姓名")
    private String name;

    @ApiModelProperty("年龄")
    private Integer age;

    @ApiModelProperty("用户头像")
    private String avatar;
}
