package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author LiBin
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel("解析阅读器的答题结果")
public class PutCourseAnswerDto implements Serializable {

    private static final long serialVersionUID = 1349552800406449784L;

    @ApiModelProperty(notes = "当前答题获取的能量石数")
    private Integer stoneNum;

    @ApiModelProperty(notes = "当前答题最终结果Good Great Perfet")
    private String result;

    @ApiModelProperty(notes = "书籍bookCode 关卡被删除会返回")
    private String bookCode;

    public PutCourseAnswerDto(Integer addStone, String result) {
        this.stoneNum = addStone;
        this.result = result;
    }
}
