package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author LiBin
 */
@ApiModel("绘本关卡信息")
@Data
public class PicBookMissionDto implements Serializable {

    private static final long serialVersionUID = 8724778679926969535L;
    @ApiModelProperty("咿啦币数")
    private String balance;

    @ApiModelProperty("能量石总数")
    private Integer stoneNum = 0;

    @ApiModelProperty(notes = "关卡id")
    private Integer id;

    @ApiModelProperty(notes = "关卡code")
    private String missionCode;

    @ApiModelProperty(notes = "图书封面url")
    private String coverUrl;

    @ApiModelProperty(notes = "图书名")
    private String bookName;

    @ApiModelProperty(notes = "图书code")
    private String bookCode;

    @ApiModelProperty(notes = "图书系列名")
    private String seriesName;

    @ApiModelProperty(notes = "蓝思级别数")
    private String lexileLevel;

    @ApiModelProperty(notes = "蓝思级别code")
    private String levelCode;

    @ApiModelProperty(notes = "出版社")
    private String publisher;

    @ApiModelProperty(notes = "关卡可获得能量石")
    private Integer missionStoneNum = 0;

    @ApiModelProperty(notes = "简介")
    private String description;

    @ApiModelProperty(notes = "预览视频url")
    private String videoUrl;

    @ApiModelProperty(notes = "动画书资源")
    private String normalUrl;

    @ApiModelProperty(notes = "iphonex资源")
    private String iphoneUrl;

    @ApiModelProperty("关卡状态 UNLOCKED:已解锁;LOCKED:未解锁")
    private String status;

    @ApiModelProperty(notes = "解锁的人数")
    private Integer lockedNum;

    @ApiModelProperty(notes = "标签(多个标签已','分割)如 标签1，标签2")
    private String tags;

    @ApiModelProperty(notes = "年龄段，已','分开 如 1,8")
    private String forAge;

    @ApiModelProperty(notes = "价格")
    private BigDecimal price = new BigDecimal(0);

    @ApiModelProperty(notes = "物料编码")
    private String goodsCode;

    @ApiModelProperty(notes = "是否可点击")
    private Boolean isClickable;

    @ApiModelProperty(notes = "地图code")
    private String mapCode;
}
