package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("地图关卡信息")
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
public class MapMissionDto implements Serializable {

    private static final long serialVersionUID = 8687015594224946370L;

    @ApiModelProperty(notes = "关卡序号")
    private Integer missionIndex;

    @ApiModelProperty(notes = "蓝思级别code")
    private String levelCode;

    @ApiModelProperty(notes = "地图所在等级位置序号")
    private Integer levelOrder;

    private String mapCode;

}
