package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("等级弹窗")
@Data
public class LevelPopupDto implements Serializable {

    private static final long serialVersionUID = 2976272588044251863L;
    @ApiModelProperty("等级主键")
    private Integer id;

    @ApiModelProperty("等级编码LV1LV2")
    private String levelCode;

    @ApiModelProperty("词汇数")
    private Integer vocabularyNum;

    @ApiModelProperty("句型数")
    private Integer grammarNum;

    @ApiModelProperty("拼读数")
    private Integer readingNum;

    @ApiModelProperty("地图数量")
    private Integer mapNum;

    @ApiModelProperty("关卡数量")
    private Integer missionNum;

    @ApiModelProperty("阅读能力指数(起始区间)")
    private Integer readStartIndex;

    @ApiModelProperty("阅读能力指数(结束区间)")
    private Integer readEndIndex;

    @ApiModelProperty("等级目标")
    private String target;

    @ApiModelProperty("目标图片")
    private String attachCode;

    @ApiModelProperty("地图id")
    private Long mapId;

    @ApiModelProperty("写作数量")
    private Integer writingNum;
}
