package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author LiBin
 */
@ApiModel("用户首页返回信息")
@Data
public class HomePageDto implements Serializable {

    @ApiModelProperty("用户uid")
    private String uid;

    @ApiModelProperty("用户等级")
    private String level;

    @ApiModelProperty("用户doing地图的等级")
    private String doingLevel;

    @ApiModelProperty("等级分数")
    private String lexileLevel;

    @ApiModelProperty(notes = "头像")
    private String avatar;

    @ApiModelProperty(notes = "英文名称")
    private String enName;

    @ApiModelProperty("当前所处地图序号")
    private Integer mapIndex = 0;

    @ApiModelProperty("进度条的总关卡数")
    private Integer totalMissionNum = 0;

    @ApiModelProperty("进度条的已过总关卡数")
    private Integer userTotalMissionNum = 0;

    @ApiModelProperty(notes = "用户当前级别的地图信息")
    private List<UserMapDto> userMapDtoList;
}
