package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author LiBin
 */
@ApiModel("考试分析结果")
@Data
public class ExamTestResultDto implements Serializable {

    private static final long serialVersionUID = -2722415340148309353L;

    @ApiModelProperty(notes = "错题数")
    private Integer errorNum;

    @ApiModelProperty(notes = "总分数")
    private Integer totalScore;

    @ApiModelProperty(notes = "获得分数")
    private Integer gotScore;

    @ApiModelProperty(notes = "评语")
    private String remark;

    @ApiModelProperty("过关答题数")
    private Integer passNum;

    @ApiModelProperty("错题集")
    private List<EnTestDto> errorTestList;

    @ApiModelProperty(notes = "本次答对题目数")
    private Integer rightNum;
}
