package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("测验题目选项列表")
@Data
public class EnTestItemsDto implements Serializable {
    private static final long serialVersionUID = 3515465283841179767L;

    @ApiModelProperty("选项id")
    private Long itemId;

    @ApiModelProperty("题目id")
    private Long questionId;

    @ApiModelProperty("选项key")
    private String itemKey;

    @ApiModelProperty("选项资源（如:图片选项）")
    private String resItem;

    @ApiModelProperty("文字选项")
    private String textItem;

    @ApiModelProperty("答案解析")
    private String answerAnalysis;

    @ApiModelProperty("是否正确选项")
    private Boolean isTrueAnswer;

}
