package com.ella.resource.dto.appdto;

import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.List;

/**
 * @author LiBin
 */
@ApiModel("测验题目列表")
@Data
public class EnTestDto implements Serializable {
    private static final long serialVersionUID = 8845007718970906464L;

    @ApiModelProperty("题目id")
    private Long questionId;

    @ApiModelProperty("题目类型 CHOICE-选择，CONNECT-连线，DRAG-拖拽，JIGSAW-拼图,RANDOM-随机")
    private String questionType;

    @ApiModelProperty("题目名称")
    private String questionName;

    @ApiModelProperty("正确答案")
    private String correctAnswer;

    @ApiModelProperty("音频")
    private String voice;

    @ApiModelProperty("选项")
    private List<EnTestItemsDto> enTestItems;

    @ApiModelProperty("内容来源")
    private NextMissionInfoDto contentFrom;

    @ApiModelProperty("用户选项")
    private String userOption;

    public EnTestDto() {
    }

    public EnTestDto(String questionType, String questionName, String correctAnswer, String voice, String userOption) {
        this.questionType = questionType;
        this.questionName = questionName;
        this.correctAnswer = correctAnswer;
        this.voice = voice;
        this.userOption = userOption;
    }
}
