package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("课后测试描述详情")
@Data
public class CourseTestInfoDto implements Serializable {

    private static final long serialVersionUID = 6847458975403087505L;

    @ApiModelProperty(notes = "关卡id")
    private Long id;

    @ApiModelProperty(notes = "关卡名字")
    private String missionName;

    @ApiModelProperty(notes = "词汇数量")
    private Integer vocabularyNum = 0;

    @ApiModelProperty(notes = "语法句型数量")
    private Integer grammarNum = 0;

    @ApiModelProperty(notes = "拼读数量")
    private Integer phonicNum = 0;

    @ApiModelProperty(notes = "关卡可获得的能量石")
    private Integer missionStoneNum = 0;

    @ApiModelProperty(notes = "题目数")
    private Integer num = 0;
}
