package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author LiBin
 */
@ApiModel("课程关卡信息")
@Data
public class CourseMissionDto implements Serializable {
    private static final long serialVersionUID = 5081754284746126612L;

    @ApiModelProperty("咿啦币数")
    private String balance;

    @ApiModelProperty("能量石总数")
    private Integer stoneNum;

    @ApiModelProperty(notes = "关卡id")
    private Long id;

    @ApiModelProperty(notes = "关卡code")
    private String missionCode;

    @ApiModelProperty(notes = "图书封面url")
    private String coverUrl;

    @ApiModelProperty(notes = "图书名")
    private String bookName;

    @ApiModelProperty(notes = "图书code")
    private String bookCode;

    @ApiModelProperty(notes = "图书系列名")
    private String seriesName;

    @ApiModelProperty(notes = "蓝思级别数")
    private String lexileLevel;

    @ApiModelProperty(notes = "蓝思级别code")
    private String levelCode;

    @ApiModelProperty(notes = "词汇数量")
    private Integer vocabularyNum = 0;

    @ApiModelProperty(notes = "语法句型数量")
    private Integer grammarNum = 0;

    @ApiModelProperty(notes = "拼读数量")
    private Integer phonicNum = 0;

    @ApiModelProperty(notes = "关卡可获得的能量石")
    private Integer missionStoneNum = 0;

    @ApiModelProperty(notes = "视频url")
    private String videoUrl;

    @ApiModelProperty(notes = "动画书资源")
    private String normalUrl;

    @ApiModelProperty(notes = "iphonex资源")
    private String iphoneUrl;

    @ApiModelProperty(notes = "价格")
    private BigDecimal price = new BigDecimal(0);

    @ApiModelProperty(notes = "物料编码")
    private String goodsCode;

    @ApiModelProperty("关卡状态 UNLOCKED:已解锁;LOCKED:未解锁")
    private String status;

    @ApiModelProperty(notes = "课程code")
    private String courseCode;

    @ApiModelProperty(notes = "课程学习进度(课堂模式 CLASSROOM ，自学模式 SELF-STUDY，测验 TEST) 空表示未开始")
    private String process = "";

    @ApiModelProperty(notes = "闯关总人数")
    private Integer courseTotalNum;

    @ApiModelProperty(notes = "闯关成功人数")
    private Integer coursePassNum;

    @ApiModelProperty(notes = "地图code")
    private String mapCode;

    @ApiModelProperty(notes = "出版社")
    private String publisher;

    @ApiModelProperty(notes = "是否可点击")
    private Boolean isClickable;

    private Integer missionIndex;

    @ApiModelProperty(notes = "通关所需能量石数")
    private Integer passNum;

    @ApiModelProperty(notes = "书籍介绍")
    private String bookIntroduction;

    @ApiModelProperty(notes = "视频预览图片url")
    private String videoPerviewPicUrl;

    @ApiModelProperty(notes = "是否读完")
    private Boolean isFinished;

    private Integer missionType;

    @ApiModelProperty(notes = "地图所在等级位置序号")
    private Integer levelOrder;

    @ApiModelProperty(notes = "版本号")
    private String version;

    @ApiModelProperty(notes = "是否是新增关卡")
    private Boolean isNew = false;

    @ApiModelProperty("蓝思指数类别code")
    private String lexileLevelCode;

    @ApiModelProperty(notes = "读书资源是否版权到期，下架")
    private String shelvesFlag;

    @ApiModelProperty("英语用书状态：YES:可用 NO：不可用(如：NO)")
    private String englishStatus;

    @ApiModelProperty("书籍是否下架")
    private Boolean available = true;

    @ApiModelProperty(notes = "关卡资源是否有更新")
    private Boolean isNewResource = false;
}
