package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;

/**
 * @author LiBin
 */
@NoArgsConstructor
@AllArgsConstructor
@Data
@ApiModel("记录课程关卡的答题详情")
public class CourseAnswerInfoDto implements Serializable {

    private static final long serialVersionUID = 4204840746084409273L;

    @ApiModelProperty(notes = "页码")
    private Integer pageNumber;

    @ApiModelProperty(notes = "当前页已获取的能量石数")
    private Integer stoneNum;

    @ApiModelProperty(notes = "当前页可获取的最大能量石数")
    private Integer maxStoneNum;

    @ApiModelProperty(notes = "书籍bookCode 关卡被删除会返回")
    private String bookCode;
}
