package com.ella.resource.dto.appdto;

import com.ella.resource.dto.missiondto.NextMissionInfoDto;
import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("分析结果")
@Data
public class AnalysisTestInfoDto implements Serializable {

    private static final long serialVersionUID = 7953470568740655031L;

    @ApiModelProperty(notes = "是否过关")
    private Boolean isPass;

    @ApiModelProperty(notes = "本关卡获得的能量石数")
    private Integer gotStoneNum;

    @ApiModelProperty(notes = "比上次多获取的能量石数")
    private Integer addGotStoneNum;

    @ApiModelProperty(notes = "本关卡获赠的能量石数")
    private Integer giveStoneNum;

    @ApiModelProperty(notes = "累计获赠的能量石数")
    private Integer gotTotalStoneNum;

    @ApiModelProperty("分析结果详情")
    private Object analysisResult;

    @ApiModelProperty("下一关卡信息")
    NextMissionInfoDto nextMissionInfo;

}
