package com.ella.resource.dto.appdto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;

/**
 * @author LiBin
 */
@ApiModel("测试分析结果")
@Data
public class AnalysisTestDto implements Serializable {

    private static final long serialVersionUID = 2940123775233460352L;

    @ApiModelProperty("咿啦币数")
    private String balance;

    @ApiModelProperty("总能量石数")
    private Integer stoneNum;

    @ApiModelProperty(notes = "英文名称")
    private String enName;

    @ApiModelProperty(notes = "出版社")
    private String publisher;

    @ApiModelProperty(notes = "蓝思级别数")
    private String lexileLevel;

    @ApiModelProperty("分析结果")
    private AnalysisTestInfoDto analysisTestInfo;

    @ApiModelProperty(notes = "蓝思指数类别code")
    private String lexileLevelCode;

    @ApiModelProperty(notes = "书籍bookCode 关卡被删除会返回")
    private String bookCode;

    @ApiModelProperty(notes = "关卡类别")
    private Integer missionType;
}
