package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javafx.util.Pair;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author mengyang
 * @dscription 描述
 * @date 2019.12.02
 */
@Data
@ApiModel("单词本导入dto")
@AllArgsConstructor
@NoArgsConstructor
@Builder
public class WordListImportDto implements Serializable {

    private static final long serialVersionUID = -2981723994558587479L;

    @ApiModelProperty(notes = "单词")
    private String word;
    @ApiModelProperty(notes = "单词对应类别、等级关系")
    private String levelAndCategory;
    @ApiModelProperty(notes = "单词对应类别、等级关系code")
    private List<String> relationCodes;
    @ApiModelProperty(notes = "单词对应图书code")
    private List<String> bookCodes;
}
