package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import javafx.util.Pair;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;
import java.util.List;
import java.util.Map;

/**
 * @author mengyang
 * @dscription 描述
 * @date 2019.12.02
 */
@Data
@ApiModel("单词本")
@AllArgsConstructor
@NoArgsConstructor
public class WordListDto implements Serializable {

    private static final long serialVersionUID = -250321713073880422L;

    @ApiModelProperty(notes = "主键ID")
    private Integer id;
    @ApiModelProperty(notes = "单词")
    private String word;
    @ApiModelProperty(notes = "类别code")
    private String categoryCode;
    @ApiModelProperty(notes = "等级code")
    private String levelCode;
    @ApiModelProperty(notes = "单词释义")
    private String explains;
    @ApiModelProperty(notes = "单词图片url")
    private String picUrl;
    @ApiModelProperty(notes = "更新时间")
    private Date updateTime;
    @ApiModelProperty(notes = "状态")
    private String status;
    @ApiModelProperty(notes = "单词对应来源bookCodes")
    private List<String> bookCodes;
    @ApiModelProperty(notes = "单词对应类别、等级关系code")
    private List<String> relationCodes;
    @ApiModelProperty(notes = "单词对应类别信息")
    private Map<String,List<Map<String,String>>> levelAndCategories;
}
