package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author mengyang
 * @dscription 描述
 * @date 2019.12.02
 */
@Data
@ApiModel("单词类别")
@AllArgsConstructor
@NoArgsConstructor
public class WordCategoryDto implements Serializable {

    private static final long serialVersionUID = 257737546126204735L;

    @ApiModelProperty(notes = "主键ID")
    private Integer id;
    @ApiModelProperty(notes = "等级code")
    private String levelCode;
    @ApiModelProperty(notes = "等级名称")
    private String levelName;
    @ApiModelProperty(notes = "类别code")
    private String categoryCode;
    @ApiModelProperty(notes = "排序")
    private Integer idx;
    @ApiModelProperty(notes = "类别名称")
    private String categoryName;
    @ApiModelProperty(notes = "类别英文名称")
    private String categoryEnName;
    @ApiModelProperty(notes = "类别图片url")
    private String categoryImgUrl;
    @ApiModelProperty(notes = "单词数量")
    private String wordsNum;
    @ApiModelProperty(notes = "主键ID")
    private Date updateTime;
    @ApiModelProperty(notes = "类别状态")
    private String status;
    @ApiModelProperty(notes = "类别等级关系relationCode")
    private String relationCode;

}
