package com.ella.resource.dto;

import javax.validation.constraints.NotNull;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

/**
 * 开始蓝思评测请求
 * 
 * @author maofengHan
 *
 */
@Data
@ApiModel("开始蓝思评测请求")
public class StartLexileEvaluationRequest {

	@ApiModelProperty(value = "继续上次未完成评测记录ID(<=0时创建新的测试记录，否则延续上次未完成的测试)", hidden = true)
	private Long continuteLastEvalutionHistoryId = 0L;

	@NotNull
	@ApiModelProperty(value = "本次评测ID", required = true)
	private Long currentEvaluationId;

	@NotNull
	@ApiModelProperty(value = "用户ID", required = true, hidden = true)
	private String uid;

	@ApiModelProperty(value = "用户年龄", required = false, hidden = true)
	private Integer age = 3;

	@ApiModelProperty(value = "用户等级代码", required = true, hidden = true)
	private String levelCode;
}
