package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Map;

import javax.validation.constraints.NotNull;

import com.ella.resource.dto.sendgoods.ResTypeEnum;

import io.swagger.annotations.ApiModel;
import lombok.Data;

@Data
@ApiModel("保存资源占用信息")
public class SaveResOccupantRequest implements Serializable{
	
	private static final long serialVersionUID = -6509120846928605398L;
	
	/**
	 * 占用资源 键值对 key - 资源编码 ，value - 占用方id
	 * */
	@NotNull
	private Map<String,Long> resIds;
	
	/**
	 * 资源类型
	 * */
	@NotNull
	private ResTypeEnum resType;
	
	/**
	 * 占用者类型(课程：COURSE，绘本馆PICTUREBOOK,考试：EXAM,测试：TEST,关卡：MISSION,商品: GOODS)
	 * */
	@NotNull
	private String occuType;

}
