package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("题目列表")
public class ResQuestionListDto implements Serializable {
	private static final long serialVersionUID = -6495718038076222510L;
	@ApiModelProperty("主键ID")
	private Long id;
	
	@ApiModelProperty("题目等级ID")
	private String questionLevelId;

	@ApiModelProperty("题目等级名称")
	private String questionLevelName;

	@ApiModelProperty("题目类型 CHOICE-选择，CONNECT-连线，DRAG-拖拽，JIGSAW-拼图,RANDOM-随机")
	private String questionType;

	@ApiModelProperty("题目名称")
	private String questionName;

	@ApiModelProperty("分值")
	private Integer score;

	@ApiModelProperty("书名")
	private String bookName;

	@ApiModelProperty("知识点")
	private String knowledgePoint;

	@ApiModelProperty("知识点类型")
	private String knowledgeType;

	@ApiModelProperty("音频(题目类型为选择题时使用该字段)")
	private String voice;

	@ApiModelProperty("正确答案")
	private String correctAnswer;
	
	@ApiModelProperty("题目使用状态 (N-未使用，Y-已使用)")
	private String useStatus;

	@ApiModelProperty("创建人")
	private String createBy;

	@ApiModelProperty("创建时间")
	private Date createTime;

	@ApiModelProperty("修改人")
	private String updateBy;

	@ApiModelProperty("修改时间")
	private Date updateTime;

	@ApiModelProperty("数据状态(NORMAL-正常,DELETE-删除)")
	private String status;

}
