package com.ella.resource.dto;

import java.io.Serializable;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;
@Data
@ApiModel("题目选项列表")
public class ResQuestionItemDto implements Serializable{
	private static final long serialVersionUID = -5045260315883946532L;

	@ApiModelProperty(notes="题目选项Id")
	private Long id;

	@ApiModelProperty(notes="选项key（注：有序。题目类型为拼图时，选项key升序代表拼图正确答案）")
	private String itemKey;

	@ApiModelProperty(notes="选项资源（如:图片选项）")
	private String resItem;

	@ApiModelProperty(notes="文字选项")
	private String textItem;

	@ApiModelProperty(notes="是否多选（适用对象：题目类型未选择题）")
	private Boolean isMultiChocie;

	@ApiModelProperty(notes="答案解析")
	private String answerAnalysis;

	@ApiModelProperty(notes="是否正确答案（适用对象：题目类型为选择题）")
	private Boolean isTrueAnswer;
}
