package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("阶段性测验列表")
public class ResPeriodTestListDto implements Serializable {

	private static final long serialVersionUID = 8653032376086238797L;

	@ApiModelProperty(notes = "测验ID")
	private Long id;

	@ApiModelProperty(notes = "测验名称")
	private String name;

	@ApiModelProperty(notes = "建议等级ID")
	private String levelId;

	@ApiModelProperty(notes = "建议等级名称")
	private String levelName;

	@ApiModelProperty(notes = "题目数")
	private Short questionNum;

	@ApiModelProperty(notes = "过关提示语")
	private String markWord;

	@ApiModelProperty(notes = "使用状态（N-未使用，Y-已使用）")
	private String useStatus;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改人")
	private String updateBy;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status;

}
