package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("考试详情")
public class ResExamDto implements Serializable{
	private static final long serialVersionUID = 1971017621276768167L;

	@ApiModelProperty(notes = "考试Id")
	private Long id;

	@ApiModelProperty(notes = "考试名称")
	private String name;

	@ApiModelProperty(notes = "建议等级ID")
	private String levelId;

	@ApiModelProperty(notes = "建议等级名称")
	private String levelName;

	@ApiModelProperty(notes = "评语，json串")
	private String remark;

	@ApiModelProperty(notes = "题目量")
	private Short questionNum;

	@ApiModelProperty(notes = "总分")
	private Integer totalScore;

	@ApiModelProperty(notes = "使用状态（N未使用，Y已使用）")
	private String useStatus;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "更新人")
	private String updateBy;

	@ApiModelProperty(notes = "更新时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态（NORMAL正常、DELETE删除）")
	private String status;
	
	@ApiModelProperty(notes = "考试详情")
	private List<ResExamDetailDto> detailList;
}
