package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("考试-题目-详情")
public class ResExamDetailDto implements Serializable{
	private static final long serialVersionUID = -3181961600322579288L;

	@ApiModelProperty(notes = "考试详情Id")
	private Long id;

	@ApiModelProperty(notes = "考试Id")
	private Long examId;

	@ApiModelProperty(notes = "题目Id")
	private Long questionId;

	@ApiModelProperty(notes = "题目顺序")
	private Short questionOrder;

	@ApiModelProperty(notes = "知识点等级")
	private String knowledgeLevel;

	@ApiModelProperty(notes = "知识点关卡")
	private String knowledgeMission;
	
	@ApiModelProperty(notes = "关卡名称")
	private String missionName;

	@ApiModelProperty(notes = "题目分数")
	private Integer questionScore;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改人")
	private String updateBy;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status;
	
	@ApiModelProperty(notes = "题目信息")
	private ResQuestionDto questionDto;
}
