package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Builder;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 蓝思评测准备数据
 *
 * @author maofengHan
 */
@Data
@Builder
@ApiModel("蓝思评测准备数据")
public class PrepareLexileEvaluationDto {

    @ApiModelProperty("上次评测时间")
    private Date lastEvaluationTime;

    @ApiModelProperty("上次评测结果")
    private String lastEvaluationResult;

    @ApiModelProperty("上次评测状态（UNDERWAY:进行中/UNCOMPLETED:未完成/COMPLETED:已完成）")
    private String lastEvaluationStatus;

    @ApiModelProperty("上次评测记录ID")
    private Long lastEvaluationRecordId;

    @ApiModelProperty("本次等级评测ID")
    private Long currentEvaluationId;

    @ApiModelProperty("本次评测题目数量")
    private Integer currentEvaluationQuestionNum;

    @ApiModelProperty("预计消耗能量石数量")
    private Integer stoneNum;

    @ApiModelProperty("预计需要时间（分钟）")
    private Integer expectCostMinutes;

    @ApiModelProperty("等级代码")
    private String levelCode;

    @ApiModelProperty("是否已通过")
    private String isPass;

    @ApiModelProperty("是否可以开启新的评测")
    private Boolean enableStart;

    @ApiModelProperty("是否已解锁")
    private Boolean unlocked;

    @ApiModelProperty("非ios账户")
    private BigDecimal balance;

    @ApiModelProperty("ios账户")
    private BigDecimal iosBalance;

    @ApiModelProperty("能量石余额")
    private Integer stoneBalance;

    @ApiModelProperty(notes = "关卡序号")
    private Integer missionIndex;

    @ApiModelProperty(notes = "地图所在等级位置序号")
    private Integer levelOrder;

    @ApiModelProperty(notes = "是否可点击--需求顺序解锁")
    private Boolean isClickable;

    @ApiModelProperty(notes = "是否可点击--需求顺序解锁")
    private String lastEvaluationLevelCode;

    @ApiModelProperty(notes = "下一个地图id")
    private String nextMapId;
}
