package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

/**
 * @author LiBin
 */
@ApiModel("关卡信息")
@Data
public class PictureBookListDto implements Serializable {
    private static final long serialVersionUID = 421774513908406615L;

    @ApiModelProperty(notes = "主键")
    private Integer id;

    @ApiModelProperty(notes = "蓝思级别")
    private String lexileLevel;

    @ApiModelProperty(notes = "绘本编码")
    private String picBookCode;

    @ApiModelProperty(notes = "绘本名称")
    private String bookName;

    @ApiModelProperty(notes = "顺序")
    private Integer idx;

    @ApiModelProperty(notes = "价格")
    private String price;

    @ApiModelProperty(notes = "修改时间")
    private Date updateTime;
}
