package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@ApiModel("绘本信息")
@Data
public class PictureBookDto implements Serializable{

	private static final long serialVersionUID = 3130956555147438439L;
	
	@ApiModelProperty("绘本编码")
	private String picBookCode;
	
	@ApiModelProperty("关联动画书code")
    private String bookCode;
	
	@ApiModelProperty("系列名")
    private String seriesName;
	
	@ApiModelProperty("适用年龄")
    private String forAge;
	
	@ApiModelProperty("绘本名")
    private String bookName;
	
	@ApiModelProperty("蓝思指数")
    private String lexileLevel;
	
	@ApiModelProperty("标签")
    private String tags;
	
	@ApiModelProperty("获取能量石个数")
    private Integer stoneNum;
	
	private Integer id;
	
	@ApiModelProperty("视频url")
    private String videoUrl;
	
	@ApiModelProperty("过关提示语")
    private String winTips;
	
	@ApiModelProperty("未过关提示语")
    private String failTips;
	
	@ApiModelProperty("简介")
    private String description;
	
	@ApiModelProperty("使用状态 (N-未使用，Y-已使用)")
    private String useStatus;
	
	@ApiModelProperty("EXCEPTION:不可用 ,NORMAL:可用")
    private String status;
	
	@ApiModelProperty("创建时间")
    private Date createTime;
	
	@ApiModelProperty("修改时间")
    private Date updateTime;
}
