package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;

/**
 * @author ZLN
 * @create 2018-08-06 10:35
 **/
@Data
@ApiModel("我的绘本返回值")
public class PicBookStoreDto  implements Serializable {
    private static final long serialVersionUID = 2056866606266526485L;

    @ApiModelProperty("商品code")
    private String goodsCode;

    @ApiModelProperty("图书名称")
    private String goodsName;

    @ApiModelProperty("图书级别")
    private String levelCode;

    @ApiModelProperty("封面")
    private String coverUrl;

    @ApiModelProperty("绘本")
    private String picBookCode;

    @ApiModelProperty("绘本资源URL")
    private String resourceUrl;

    @ApiModelProperty("蓝思值")
    private String lexileLevel;

    @ApiModelProperty("是否已购")
    private boolean bought;

    private String bookCode="";

    private String bookIntroduction;

    private Float bookScore;

    private String tags;

    @ApiModelProperty("蓝思指数类别code")
    private String lexileLevelCode="";

    @ApiModelProperty(notes = "图书资源版本号")
    private String version;

    @ApiModelProperty("书籍是否下架")
    private Boolean available = true;

    //咿啦看书  英语合并
    @ApiModelProperty(notes = "商品价格")
    private BigDecimal goodsPriceStone;

    @ApiModelProperty(notes = "能量石兑换价格")
    private BigDecimal goodsPrice;
}
