package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author LiBin
 */
@ApiModel("地图信息")
@Data
public class MapDto implements Serializable {

    private static final long serialVersionUID = -3620331539931634430L;
    @ApiModelProperty("主键")
    private Long id;

    @ApiModelProperty("code")
    private String mapCode;

    @ApiModelProperty("地图名称")
    private String mapName;

    @ApiModelProperty("地图所在等级位置序号")
    private Integer levelOrder;

    @ApiModelProperty("所属等级code")
    private String levelCode;

    @ApiModelProperty("所属等级名称")
    private String levelName;

    @ApiModelProperty("所属单元预留")
    private String unit;

    @ApiModelProperty("关卡数量")
    private Integer missionNum = 0;

    @ApiModelProperty("背景图片")
    private String backgroundUrl;

    @ApiModelProperty("创建时间")
    private Date createTime;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("数据状态(SURE-已确认,UNSURE-待确认,DELETE-删除)")
    private String status;

    @ApiModelProperty("地图动效")
    private String dynamicUrl;

    @ApiModelProperty("地图图标")
    private String icoUrl;

    @ApiModelProperty("地图底部图片")
    private String bottomUrl;

    private String androidVerion;

    private String iosVersion;

    private String createBy;

    private String updateBy;

    private Integer stoneNum;

    /**
     * 是否是用户地图 false 是 true 否
     */
    private Boolean userMapFlag;

}
