package com.ella.resource.dto;

import java.util.Date;
import java.util.List;
import java.util.Map;

import com.ella.resource.constants.LexileEvaluationStatusEnum;
import com.ella.resource.dto.request.question.QuestionLexileRecordDto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("蓝思定级/晋级评测记录")
public class LexileLevelHistoryDto {

	@ApiModelProperty(value = "主键ID(评测记录ID)")
	private Integer id;

	@ApiModelProperty(value = "用户UID")
	private String uid;

	@ApiModelProperty(value = "评测ID")
	private Integer evaluationId;

	@ApiModelProperty(value = "用户年龄")
	private Integer age;

	@ApiModelProperty(value = "题目数量")
	private Integer testNum;

	@ApiModelProperty(value = "答题正确数量")
	private Integer correctNum;

	@ApiModelProperty(value = "评测后等级")
	private String levelCode;

	@ApiModelProperty(value = "原始等级")
	private String originLevelCode;

	@ApiModelProperty(value = "蓝思原始分数")
	private Integer lexileScore;

	@ApiModelProperty(value = "蓝思标准误差")
	private Integer lexileSem;

	@ApiModelProperty(value = "蓝思值")
	private String lexileLevel;

	@ApiModelProperty(value = "开始时间")
	private Date startTime;

	@ApiModelProperty(value = "完成时间")
	private Date endTime;

	@ApiModelProperty(value = "是否晋级")
	private Boolean promotion;

	@ApiModelProperty(value = "状态（UNDERWAY:进行中/UNCOMPLETED:未完成/COMPLETED:已完成）")
	private String status;

	@ApiModelProperty(value = "创建时间")
	private Date createTime;

	@ApiModelProperty(value = "评测详情")
	private LexileEvaluationDto evaluation;

	@ApiModelProperty(value = "答题记录详情", hidden = true)
	private List<QuestionLexileRecordDto> answerRecords;
}
