package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Date;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("蓝思题目选项信息")
public class LexileEvaluationQuestionItemDto implements Serializable{
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "主键ID")
	private Long id;

	@ApiModelProperty(notes = "问题id")
	private Long questionId;

	@ApiModelProperty(notes = "选项key(ABCD)")
	private String optionKey;

	@ApiModelProperty(notes = "选项内容")
	private String optionContent;

	@ApiModelProperty(notes = "选项类型 文字word、图片picture")
	private String optionType;

	@ApiModelProperty(notes = "是否是多选")
	private Boolean isMultiChocie;

	@ApiModelProperty(notes = "是否是正确答案")
	private Boolean isTrueAnswer;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改人")
	private String updateBy;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status;
}
