package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("蓝思题目信息")
public class LexileEvaluationQuestionDto implements Serializable {

	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "主键ID")
	private Long id;

	@ApiModelProperty(notes = "评测id")
	private Long evaluationId;

	@ApiModelProperty(notes = "知识点所属等级")
	private String knowledgeLevel;

	@ApiModelProperty(notes = "知识点所属关卡")
	private String knowledgeMission;

	@ApiModelProperty(notes = "题目分数")
	private int questionScore;

	@ApiModelProperty(notes = "顺序")
	private Integer idx;

	@ApiModelProperty(notes = "体裁")
	private String genre;

	@ApiModelProperty(notes = "问题类型")
	private String questionType;

	@ApiModelProperty(notes = "问题描述")
	private String questionText;

	@ApiModelProperty(notes = "问题描述单词量")
	private Integer wordCount;

	@ApiModelProperty(notes = "问题主干")
	private String questionStem;

	@ApiModelProperty(notes = "蓝思信息")
	private String formId;

	@ApiModelProperty(notes = "蓝思信息")
	private String formName;

	@ApiModelProperty(notes = "蓝思信息")
	private String imsId;

	@ApiModelProperty(notes = "创建人")
	private String createBy;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改人")
	private String updateBy;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status;

	@ApiModelProperty(notes = "题目选项信息")
	private List<LexileEvaluationQuestionItemDto> questionItemDtoList;
}
