package com.ella.resource.dto;

import java.io.Serializable;
import java.util.Date;

import com.github.pagehelper.PageInfo;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

@Data
@ApiModel("蓝思评测信息")
public class LexileEvaluationPageDto implements Serializable {
	private static final long serialVersionUID = 1L;

	@ApiModelProperty(notes = "主键ID")
	private Long id;

	@ApiModelProperty(notes = "等级ID")
	private Long levelId;

	@ApiModelProperty(notes = "评测预计消耗时间（分钟）")
	private Integer expectedTime;

	@ApiModelProperty(notes = "评测需要消耗的能量石数量")
	private Integer stoneNum;

	@ApiModelProperty(notes = "评测考试的名称")
	private String evaluationName;

	@ApiModelProperty(notes = "创建时间")
	private Date createTime;

	@ApiModelProperty(notes = "修改时间")
	private Date updateTime;

	@ApiModelProperty(notes = "数据状态(NORMAL-正常,DELETE-删除)")
	private String status;
	
	@ApiModelProperty(notes ="考题信息")
	private PageInfo<LexileEvaluationQuestionListDto> questionDtoList;
}
