package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;

/**
 * @author LiBin
 */
@ApiModel("等级列表")
@Data
public class LevelListDto implements Serializable {

    private static final long serialVersionUID = -1175147048630615099L;
    @ApiModelProperty("主键")
    private Integer id;

    @ApiModelProperty("等级编码LV1LV2")
    private String levelCode;

    @ApiModelProperty("等级别名(启蒙者)")
    private String levelName;

    @ApiModelProperty("序号")
    private Integer levelIndex;

    @ApiModelProperty("0:待确认1:修改中2:已确认")
    private Integer useStatus;

    @ApiModelProperty("地图数量")
    private Integer mapNum;

    @ApiModelProperty("最多可获得能量石数")
    private Integer maxStoneNum;

    @ApiModelProperty("修改时间")
    private Date updateTime;

    @ApiModelProperty("数据状态(NORMAL-正常,DELETE-删除)")
    private String status;
}
