package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.AllArgsConstructor;
import lombok.Builder;
import lombok.Data;
import lombok.NoArgsConstructor;

import java.io.Serializable;
import java.util.Date;

/**
 * @author liyuanyuan
 * @dscription 描述
 * @date 2019/11/15 17:14
 */
@Data
@Builder
@AllArgsConstructor
@NoArgsConstructor
@ApiModel("Ira二级指标")
public class IraSecondAbilityReportDto implements Serializable {

    private static final long serialVersionUID = -4185667870827424412L;

    @ApiModelProperty(notes = "主键ID")
    private Integer id;

    @ApiModelProperty(notes = "一级指标code")
    private String firstCode;

    @ApiModelProperty(notes = "二级指标得分")
    private Integer rateScore;

    @ApiModelProperty(notes = "一级指标类型")
    private Integer firstType;

    @ApiModelProperty(notes = "二级指标类型")
    private Integer secondType;

    @ApiModelProperty(notes = "排序")
    private Integer idx;

    @ApiModelProperty(notes = "报告最近一次生成时的时间")
    private Date reportTime;

    @ApiModelProperty(notes = "是否可用状态")
    private String status;

    /**
     * 展示状态 BEGINNING：进行中、UNLOCKED：未解锁、NOT_INSPECT：未考察
     */
    @ApiModelProperty(notes = "展示状态")
    private String showStatus;

}
