package com.ella.resource.dto;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import lombok.Data;

import java.io.Serializable;
import java.util.Date;
import java.util.List;

/**
 * @author liyuanyuan
 * @dscription 描述
 * @date 2019/11/15 15:40
 */
@Data
@ApiModel("Ira报告信息")
public class IraReportDto implements Serializable {

    private static final long serialVersionUID = 4072910262570292587L;

    @ApiModelProperty(notes = "主键ID")
    private Long id;

    @ApiModelProperty(notes = "报表code")
    private String reportCode;

    @ApiModelProperty(notes = "uid")
    private String uid;

    @ApiModelProperty(notes = "地图Code")
    private String mapCode;

    @ApiModelProperty(notes = "当前地图完成关卡数量")
    private Integer completedMissionNum;

    @ApiModelProperty(notes = "关卡总数")
    private Integer totalMission;

    @ApiModelProperty(notes = "阅读量-阅读时长（分钟）")
    private Integer readTime;

    @ApiModelProperty(notes = "阅读量-阅读时长变化量")
    private Integer readTimeIncrease;

    @ApiModelProperty(notes = "阅读量-完成课程数")
    private Integer completedCourse;

    @ApiModelProperty(notes = "阅读量-完成课程数变化量")
    private Integer completedCourseIncrease;

    @ApiModelProperty(notes = "阅读量-阅读次数")
    private Integer readCount;

    @ApiModelProperty(notes = "阅读量-阅读次数变化量")
    private Integer readCountIncrease;

    @ApiModelProperty(notes = "报告最近一次生成时的时间")
    private Date reportTime;

    @ApiModelProperty(notes = "上一次报告更新时间")
    private Date lastReportTime;

    @ApiModelProperty(notes = "首次闯关成功时间")
    private Date firstSuccessTime;

    @ApiModelProperty(notes = "该地图总通关关卡数量")
    private Integer totalPassCount;

    /**
     * true：第一次展示，false：不是第一次展示
     */
    @ApiModelProperty(notes = "是否是第一次展示")
    private boolean isFirstShow;

    /**
     * true：有新通关，false：没有新通关
     */
    @ApiModelProperty(notes = "是否有新通关")
    private boolean isNewPass;

    /**
     * true：有提升，false：没有提升
     */
    @ApiModelProperty(notes = "是否有有提升的一级指标名称")
    private boolean isFirstAbilityUp;

    /**
     * 按照“阅读量——识字能力——阅读理解——口语能力——听力理解”的顺序依次展示
     */
    @ApiModelProperty(notes = "有提升的一级指标名称")
    private String firstAbilityUpText;


    @ApiModelProperty(notes = "用户头像")
    private String avatar;

    @ApiModelProperty(notes = "用户名称")
    private String userName;

    /**
     * 一级指标
     */
    private List<IraFirstAbilityReportDto> firstAbilitys;

}
